/*

	Script che aggiunge nella tabella dei codici IVA CG28_TABCODIVA un nuovo campo
	per indicare il codice di rilancio dell'aliquota IVA (in FK) che forma la riga della CG43
	che contiene nell'importo dell'imponibile l'importo dell'imposta della nazione UE
	per la gestione del One Stop Shop (MOSS-OSS-IOSS)

*/

-------------------------------------------------------------------------------------------------------------------------

IF NOT EXISTS(SELECT * FROM SYSCOLUMNS WHERE NAME = 'CG28_OSSCOD_CG28')
	BEGIN
		ALTER TABLE CG28_TABCODIVA
			ADD CG28_OSSCOD_CG28 CHAR(4) NULL
		PRINT 'Tabella CG28_TABCODIVA: campo CG28_OSSCOD_CG28 creato'
	END
ELSE
	BEGIN
		PRINT 'Tabella CG28_TABCODIVA: campo CG28_OSSCOD_CG28 esistente, creazione non effettuata'
	END		
GO

-------------------------------------------------------------------------------------------------------------------------

IF NOT EXISTS(SELECT * FROM SYSOBJECTS WHERE NAME = 'FK_OSS_CG28_CG28')
	BEGIN
		ALTER TABLE CG28_TABCODIVA
			ADD CONSTRAINT FK_OSS_CG28_CG28
				FOREIGN KEY (CG28_OSSCOD_CG28)
					REFERENCES CG28_TABCODIVA
		PRINT 'Tabella CG28_TABCODIVA: foreign-key FK_OSS_CG28_CG28 creata'
	END
ELSE
	BEGIN
		PRINT 'Tabella CG28_TABCODIVA: foreign-key FK_OSS_CG28_CG28 esistente, creazione non effettuata'
	END		
GO

-------------------------------------------------------------------------------------------------------------------------
